#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{
	/// <summary>
	/// Summary description for IssueReturnReport.
	/// </summary>
	[TestFixture]
	public class DAL_IssueReturnReport : BaseTest 
	{
		private System.DateTime _startDate = System.DateTime.Now.AddMonths(-6);
		private System.DateTime _endDate = System.DateTime.Now.AddDays(1);

		private System.DateTime _invalidStart = System.DateTime.Now.AddMonths(6);
		private System.DateTime _invalidEnd = System.DateTime.Now.AddYears(1);

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				DataCreator.CreateIssuedBloodUnit(true);
				System.Guid issuedUnitGuid = DataCreator.GetRecordGuid("SELECT TOP 1 IssuedUnitGuid FROM IssuedUnit WHERE PatientGuid IS NOT NULL ORDER BY LastUpdateDate DESC");
				BOL.IssuedUnit issuedUnit = new BOL.IssuedUnit(issuedUnitGuid);
				issuedUnit.ReturnDateTime = System.DateTime.Now;
				issuedUnit.ReturnTechId = Common.LogonUser.LogonUserName;
				issuedUnit.ReturnFromLocationName = "DAL.IssueReturnReport.SetUp()";
				System.Collections.ArrayList units = new ArrayList();
				units.Add(issuedUnit);

				DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.ReturnIssuedUnit);

				this.RefreshData = false;
			}
		}


		[Test]
		public void GetIssueReturnReportCount_Pass()
		{
			int count = DAL.IssueReturnReport.GetIssueReturnReportCount(_startDate, _endDate, UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(true, count > 0, "Count");
		}

		[Test]
		public void GetIssueReturnReportCount_Fail()
		{
			int count = DAL.IssueReturnReport.GetIssueReturnReportCount(_invalidStart, _invalidEnd, UnitTestConfig.TestDivisionCode);
			Assert.AreEqual(0, count, "Count");
		}

		[Test]
		public void GetIssueReturnReport_Pass()
		{
			DataTable dt = DAL.IssueReturnReport.GetIssueReturnReport(_startDate, _endDate, UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(true, dt.Rows.Count >= 0, "Rows.Count");
			Assert.AreEqual(12, dt.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.IssuedUnit.IssueDateTime), TABLES.IssuedUnit.IssueDateTime);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.IssuedUnit.IssueToLocationName), TABLES.IssuedUnit.IssueToLocationName);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.IssuedUnit.ReturnDateTime), TABLES.IssuedUnit.ReturnDateTime);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.IssuedUnit.ReturnFromLocationName), TABLES.IssuedUnit.ReturnFromLocationName);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dt.Columns.Contains(ARTIFICIAL.PooledUnitsCount), ARTIFICIAL.PooledUnitsCount);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
		}

		[Test]
		public void GetIssueReturnReport_Fail()
		{
			DataTable dt = DAL.IssueReturnReport.GetIssueReturnReport(_invalidStart, _invalidEnd, UnitTestConfig.TestDivisionCode);
			
			Assert.AreEqual(0, dt.Rows.Count, "Columns.Count");
		}
	}
}

#endif
